// Listing 8-14

import java.util.Scanner;

public class Listing8_14
{
   public static void main(String[] args)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Stała równa rozmiarowi tablicy
      final int SIZE = 4;
      
      // Tablica, w której zapiszemy wyniki ze sprawdzianów
      double[] testScores = new double[SIZE];
      
      // Zmienna, w której zapiszemy sumę wyników
      double total;
      
      // Zmienna, w której zapiszemy najniższy wynik
      double lowestScore;
      
      // Zmienna, w której zapiszemy średni wynik
      double average;
      
      // Pobieramy od użytkownika wyniki ze sprawdzianów
      getTestScores(testScores);
      
      // Obliczamy sumę wyników
      total = getTotal(testScores);
      
      // Wyszukujemy najniższy wynik
      lowestScore = getLowest(testScores);
      
      // Odejmujemy od zmiennej total najniższy wynik
      total = total - lowestScore;
      
      // Obliczamy średnią: dzielimy przez 3,
      // ponieważ odrzuciliśmy najniższy wynik
      average = total / (SIZE - 1);
      
      // Wyświetlamy średni wynik
      System.out.println("Średni wynik po odrzuceniu");
      System.out.println("najniższej wartości jest równy " + average);
   }
   
   // Moduł getTestScores przyjmuje jako argument tablicę,
   // prosi użytkownika o wprowadzenie wyników
   // ze sprawdzianów i zapisuje je w tablicy
   public static void getTestScores(double[] scores)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Zmienna licznikowa
      int index;
      
      // Pobieramy poszczególne wyniki
      for (index = 0; index < scores.length; index++)
      {
         System.out.print("Wprowadź wynik ze sprawdzianu numer " + index + 1 + ": ");
         scores[index] = keyboard.nextDouble();
      }
   }
   
   // Funkcja getTotal przyjmuje jako argument tablicę liczb typu Integer;
   // zwraca sumę wartości elementów 
   public static double getTotal(double[] array)
   {
      // Zmienna licznikowa
      int index;
      
      // Akumulator zainicjalizowany wartością 0
      double total = 0.0;
      
      // Obliczamy sumę wartości elementów tablicy
      for (index = 0; index < array.length; index++)
      {
         total = total + array[index];
      }
      
      // Zwracamy sumę
      return total;
   }
   
   // Funkcja getLowest przyjmuje jako argument tablicę liczb typu double
   // a następnie zwraca najmniejszą wartość w tablicy
   public static double getLowest(double[] array)
   {
      // Zmienna, w której zapiszemy najmniejszą wartość
      double lowest;
      
      // Zmienna licznikowa
      int index;
            
      // Pobieramy pierwszy element tablicy
      lowest = array[0];
      
      // Śledzimy pozostałe elementy tablicy; jeżeli wartość elementu
      // jest mniejsza niż zmienna lowest, przypisujemy ją do zmiennej lowest
      for (index = 0; index < array.length; index++)
      {
         if (array[index] < lowest)
            lowest = array[index];
      }
      
      // Zwracamy najmniejszą wartość
      return lowest;
   }
}